/* ACM ICPC -- CERC 2011
 *
 * Solution by: Josef Cibulka for the problem: Racing Car Trails (trails)
 * Idea: Alice wins from v iff v is in every maximum-size matching
 */ 
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer; 



public class trail
{
	final static int MAXN=4096;

	final static int dirh[] = {0,1,0,-1};
	final static int dirv[] = {-1,0,1,0};
	
	int ver[];
	int match[]; // the matched vertex
	int part[]; // the partition
	int ncnt[]; // number of neighbors
	int neigh[][]; // lists of neighbors
	int w, h, n;
	String board[];
	
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	String nextToken() throws Exception {
		while (!st.hasMoreTokens()) st = new StringTokenizer(input.readLine());
		return st.nextToken();
	}
	int nextInt() throws Exception {
		int ret = Integer.parseInt(nextToken());
		return ret;
	} 

	public static void main(String[] args) throws Exception 
	{
		trail inst = new trail();
		for(int ii=1; ; ii++)
		{
			if (!inst.run(ii)) break;
		}
	}

	boolean is_empty(int r, int c)
	{
		return (r>=0 && r<h && c>=0 && c<w && board[r].charAt(c)=='.');
	}


	void improve_matching(int end, int[] prev)
	{
		while(end!=-1)
		{
			assert(prev[end]!=-1);
			match[end] = prev[end];
			match[prev[end]] = end;
			end = prev[prev[end]];
		}
	}

	boolean find_improving(int q[], int qend, boolean do_improve)
	{
		boolean inq[] = new boolean[n];
		int prev[] = new int[n];
		int qbeg = 0;
		for(int i=qbeg; i<qend; i++) { inq[q[i]] = true; prev[q[i]] = -1; }
		while(qend>qbeg)
		{
			int v = q[qbeg++];
			if(part[v]==part[q[0]]) // follow a non-matching edge
			{
				for(int i=0; i<ncnt[v]; i++) 
				{
					int u = neigh[v][i];
						
					if(!inq[u])
					{
						q[qend++] = u;
						prev[u] = v;
						inq[u] = true;
						if(match[u]==-1) // improving path found
						{
							if(do_improve) improve_matching(u, prev);
							return true;
						}
					}
				}
			}
			else // follow a matching edge
			{
				int u = match[v];
				if(u!=-1 && !inq[u])
				{
					q[qend++] = u;
					prev[u] = v;
					inq[u] = true;
				}
			}
		}
		return false;
	}
	
	
	boolean run(int ii) throws Exception 
	{
		h = nextInt();
		if (h<=0) return false;
		w = nextInt();
		board = new String[h];
		for(int i=0; i<h; i++) board[i] = nextToken();
		
		n = w*h;
		ver = new int[n];
		ncnt = new int[n]; // initialized to 0
		neigh = new int[n][4];
		match = new int[n];
		part = new int[n];
		for(int i=0;i<n;i++) part[i] = -1; // -1 == wall
		
		for(int i=0; i<h; i++) 
			for(int j=0; j<w; j++) 
				if(board[i].charAt(j)=='.')
				{
					int tmp = w*i+j;
					part[tmp] = ((i+j)&1);
					for(int d=0; d<4; d++)
						if(is_empty(i+dirv[d], j+dirh[d]))
						{
							int tmp2 = (i+dirv[d])*w + j+dirh[d];
							neigh[tmp][ncnt[tmp]++] = tmp2;
						}
				}
		for(int i=0;i<n;i++) match[i]=-1;
		int q[] = new int[n];
		int qsize;
		do
		{
			qsize=0;
			for(int i=0;i<n;i++) if(match[i]==-1 && part[i]==0)
			{
				q[qsize++] = i;
			}
		} while(find_improving(q, qsize, true));
		
		for(int i=0;i<h;i++)
		{
			char newrow[] = board[i].toCharArray();
			for(int j=0;j<w;j++)
				if(newrow[j]=='.')
				{
					int tmp = w*i+j;
					if(match[tmp]==-1) newrow[j] = 'B';
					else
					{
						// try if the matched edge can be "pushed away" by 
						// an alternating path ending in an unmatched vertex
						q[0] = match[tmp];
						qsize = 1;
						if(find_improving(q, qsize, false)) newrow[j] = 'B';
						else newrow[j] = 'A';
					}
				}
			System.out.println(newrow);
		}			
		System.out.println();
		return true;
	}

}
