/*
 * ACM ICPC - CERC 2011
 *
 * Sample solution: trails
 * Author: Zdenek Dvorak
 */
#include <stdio.h>
#define M 100

typedef struct
{
  int r, c;
} point;

static char map[M][M+1];
static point mwith[M][M];
static int n, e;

static point
pt (int r, int c)
{
  point ret;
  ret.r = r;
  ret.c = c;
  return ret;
}

static int
pteq (point p1, point p2)
{
  return p1.r == p2.r && p1.c == p2.c;
}

static void
match (point p1, point p2)
{
  mwith[p1.r][p1.c] = p2;
  mwith[p2.r][p2.c] = p1;
}

static void
try_match (point p)
{
  if (p.c < e - 1 && map[p.r][p.c+1] != 'X' && mwith[p.r][p.c+1].r < 0)
    {
      match (p, pt (p.r, p.c+1));
      return;
    }
  if (p.r < n - 1 && map[p.r+1][p.c] != 'X' && mwith[p.r+1][p.c].r < 0)
    {
      match (p, pt (p.r+1, p.c));
      return;
    }
}

static void
initial_matching (void)
{
  int i, j;

  for (i = 0; i < n; i++)
    for (j = 0; j < e; j++)
      mwith[i][j].r = -1;

  for (i = 0; i < n; i++)
    for (j = 0; j < e; j++)
      if (mwith[i][j].r < 0 && map[i][j] != 'X')
	try_match (pt (i,j));
}

static point from[M][M];
static point queue[M*M];
static int fq, tq;

static void
altmatch (point p)
{
  point f1, f2;
  while (1)
    {
      f1 = from[p.r][p.c];
      if (f1.r < 0)
	return;

      f2 = from[f1.r][f1.c];
      match (f1, f2);
      p = f2;
    }
}

static void
swap_path (point f, point t)
{
  match (f, t);
  altmatch (f);
  altmatch (t);
}

static int
find_path (point f, point t)
{
  point m, frm = from[t.r][t.c];

  if (map[t.r][t.c] == 'X')
    return 0;

  if (pteq (mwith[f.r][f.c], t))
    return 0;

  m = mwith[t.r][t.c];
  if (m.r < 0 || pteq (frm, m))
    {
      swap_path (f, t);
      return 1;
    }

  if (frm.c >= 0)
    return 0;

  from[t.r][t.c] = f;
  from[m.r][m.c] = t;

  queue[tq++] = m;
  return 0;
}

static int
improve (void)
{
  int i, j;

  fq = tq = 0;

  for (i = 0; i < n; i++)
    for (j = 0; j < e; j++)
      {
	from[i][j].r = -1;
	if (map[i][j] != 'X' && mwith[i][j].r < 0)
	  {
	    queue[tq++] = pt (i,j);
	    from[i][j].c = 0;
	  }
	else
	  from[i][j].c = -1;
      }

  while (tq > fq)
    {
      point a = queue[fq++];

      if (a.r < n - 1 && find_path (a, pt (a.r+1,a.c)))
	return 1;
      if (a.r > 0 && find_path (a, pt (a.r-1,a.c)))
	return 1;
      if (a.c < e - 1 && find_path (a, pt (a.r,a.c+1)))
	return 1;
      if (a.c > 0 && find_path (a, pt (a.r,a.c-1)))
	return 1;
    }

  return 0;
}

int main(void)
{
  int i, j;

  while (scanf ("%d%d", &n, &e) == 2)
    {
      if (!n) break;
      for (i = 0; i < n; i++)
	scanf ("%s", map[i]);

      initial_matching ();
      while (improve ())
	continue;

      for (i = 0; i < n; i++)
	for (j = 0; j < e; j++)
	  {
	    point old;

	    if (map[i][j] == 'X')
	      continue;
	    if (mwith[i][j].r < 0)
	      {
		map[i][j] = 'B';
		continue;
	      }
	    old = mwith[i][j];
	    mwith[i][j].r = -1;
	    mwith[old.r][old.c].r = -1;
	    map[i][j] = 'X';
	    if (improve ())
	      map[i][j] = 'B';
	    else
	      {
		map[i][j] = 'A';
		match (pt (i,j), old);
	      }
	  }
      for (i = 0; i < n; i++)
	printf ("%s\n", map[i]);
      printf ("\n");
    }

  return 0;
}
