/*
 * ACM ICPC - CERC 2011
 *
 * Sample solution: The Grille (grille)
 * Author: Martin Kacer
 */

import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer;

public class grille {
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	public static void main(String[] args) throws Exception {
		grille instance = new grille();
		while (instance.run()) {/*repeat*/}
	}
	String nextToken() throws Exception {
		while (!st.hasMoreTokens()) st = new StringTokenizer(input.readLine());
		return st.nextToken();
	}
	int nextInt() throws Exception {
		return Integer.parseInt(nextToken());
	}
	
	final static int MAX_SIZE = 1000;
	
	char[][] text = new char[MAX_SIZE][], mesh = new char[MAX_SIZE][];
	int[][][] dirs = {{{1,0},{0,1}}, {{0,-1},{1,0}}, {{-1,0},{0,-1}}, {{0,1},{-1,0}}};
	
	boolean run() throws Exception {
		int size = nextInt();
		if (size == 0) return false;
		for (int i = 0; i < size; ++i) mesh[i] = nextToken().toCharArray();
		for (int i = 0; i < size; ++i) text[i] = nextToken().toCharArray();
		for (int d = 0; d < 4; ++d)
			for (int i = 0; i < size; ++i) for (int j = 0; j < size; ++j) {
				int di = (i+1)*dirs[d][0][0]+(j+1)*dirs[d][0][1], dj = (i+1)*dirs[d][1][0]+(j+1)*dirs[d][1][1];
				if (di < 0) di += size; else --di; if (dj < 0) dj += size; else --dj;
				if (mesh[di][dj] != '#')
					System.out.append(text[i][j]);
			}
		System.out.println();
		return true;
	}
}
