/*
 * ACM ICPC - CERC 2011
 *
 * Sample solution: Stack Machine Executor (execute)
 * Author: Josef Cibulka
 */
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.StringTokenizer; 

public class execute
{
	public static final int MAXSSIZE = 1000;
	public static final int MAXINSTR = 100000;
	public static final int MAXVAL = 1000000000;
	public static int[] stack;
	public static int ssize;
	public static Instr instr[];
		
	class Instr // a single instruction
	{
		String type;
		int val;
		
		public Instr(String _type) throws Exception
		{
			type = _type;
			if(type.contentEquals("NUM")) val = nextInt();
		}
		
		int apply(int[] stack, int ssize)
		{
			if(type.contentEquals("NUM")) 
			{ 
				stack[ssize++] = val; 
			}
			else if(type.contentEquals("POP"))
			{ 
				if(ssize<1) return -1; 
				ssize--;  
			}
			else if(type.contentEquals("INV"))
			{ 
				if(ssize<1) return -1; 
				stack[ssize-1] *=-1;  
			}
			else if(type.contentEquals("DUP"))
			{ 
				if(ssize<1) return -1; 
				int res = stack[ssize-1];  
				stack[ssize++] = res;
			}
			else if(type.contentEquals("SWP"))
			{ 
				if(ssize<2) return -1; 
				int tmp = stack[ssize-1]; stack[ssize-1] = stack[ssize-2]; stack[ssize-2] = tmp;
			}
			else if(type.contentEquals("ADD"))
			{ 
				if(ssize<2) return -1; 
				long res = (long)stack[ssize-1] + (long)stack[ssize-2]; 
				if(Math.abs(res)>MAXVAL) return -1;
				stack[ssize-2] = (int)res;
				ssize--;
			}
			else if(type.contentEquals("SUB"))
			{ 
				if(ssize<2) return -1; 
				long res = (long)stack[ssize-2] - (long)stack[ssize-1]; 
				if(Math.abs(res)>MAXVAL) return -1;
				stack[ssize-2] = (int)res;
				ssize--;
			}
			else if(type.contentEquals("MUL"))
			{ 
				if(ssize<2) return -1; 
				long res = (long)stack[ssize-2] * (long)stack[ssize-1]; 
				if(Math.abs(res)>MAXVAL) return -1;
				stack[ssize-2] = (int)res;
				ssize--;
			}
			else if(type.contentEquals("DIV"))
			{ 
				if(ssize<2 || stack[ssize-1]==0) return -1; 
				int res = Math.abs(stack[ssize-2]) / Math.abs(stack[ssize-1]);
				res *= Math.signum(stack[ssize-2]) * Math.signum(stack[ssize-1]);
				stack[ssize-2] = res;
				ssize--;
			}
			else if(type.contentEquals("MOD"))
			{ 
				if(ssize<2 || stack[ssize-1]==0) return -1; 
				int res = Math.abs(stack[ssize-2]) % Math.abs(stack[ssize-1]);
				res *= Math.signum(stack[ssize-2]);
				stack[ssize-2] = res;
				ssize--;
			}
			else { System.out.println("Unknown operation\n"); assert(false); }
			return ssize;
		}
	}
		
	StringTokenizer st = new StringTokenizer("");
	BufferedReader input = new BufferedReader(new InputStreamReader(System.in));
	String nextToken() throws Exception {
		while (!st.hasMoreTokens()) st = new StringTokenizer(input.readLine());
		return st.nextToken();
	}
	int nextInt() throws Exception {
		int ret = Integer.parseInt(nextToken());
		return ret;
	} 

	public static void main(String[] args) throws Exception 
	{
		execute inst = new execute();
		while(true)
		{
			try
			{
				instr = new Instr[MAXINSTR];
				stack = new int[MAXSSIZE];
				inst.run();
			} 
			catch(Exception e)	{	return;	}
		}
	}
	
	
	boolean run() throws Exception 
	{
		int instr_cnt;
		for(instr_cnt = 0; ; instr_cnt++)
		{
			String str = nextToken();
			if(str.contentEquals("QUIT")) throw new Exception();
			if(str.contentEquals("END")) break;
			instr[instr_cnt] = new Instr(str);
		}

		int n = nextInt();

		for(int ii=0; ii<n; ii++)
		{
			stack[0] = nextInt();
			ssize = 1;
			int i;
			for(i=0; i<instr_cnt; i++) if((ssize=instr[i].apply(stack, ssize))==-1) break;
			if(i == instr_cnt && ssize==1) System.out.println(stack[0]);
			else System.out.println("ERROR");
		}
		System.out.println();
		return true;
	}
}
