/*
 * CTU Open Contest 2011
 *
 * Sample solution: encrypt
 * Author: Jan Stoklasa
*/
 
#include <iostream>
#include <string>
#include <map>
 
using namespace std;
 
const int FirstRowShift = 1;
const int Alpha = 'Z' - 'A' + 1;
const char Any = '.';
 
char sub(char x, char y)
{
  return 'A'+(x-y-FirstRowShift+Alpha)%Alpha;	
}
 
string decrypt(const string& key, const string& ciphertext)
{
  string s(ciphertext);
  int n = ciphertext.length();
  int m = key.length();
  for(int i=0; i<n; i++)
  {
    s[i] = sub(ciphertext[i],key[i%m]);
  }
  return s;
}
 
void get_keys(int k, multimap<string, int>& keys, const string& c, const string& w)
{
  int wn = w.length();
  int n = c.length();
  string key(k,Any);
  keys.clear();
  for (int i=0; i<=n-wn; i++)
  {
    for (int j=0; j<k; j++)
    {
      key[(i+j)%k] = sub(c[i+j],w[j]);
    }
    for (int j=k; j<wn; j++)
    {
      if(key[(i+j)%k] != sub(c[i+j],w[j]))
      {
	goto impossible;
      }
    }
    keys.insert(make_pair(key, i));
impossible:;
  }
}
 
int main(void)
{
  multimap<string,int> keys1,keys2;
  int K;
  string w1, w2, c;
  while (cin >> K && K !=0 && cin >> w1 && cin >> w2 && cin >> c)
  {
    int n = c.length();
    string key;
    for (int k=1; k<=K; k++)
    {
      get_keys(k, keys1, c, w1);
      get_keys(k, keys2, c, w2);    
      for (multimap<string, int>::const_iterator it1 = keys1.begin(); it1 != keys1.end(); ++it1)
      {
	pair<multimap<string, int>::const_iterator, multimap<string, int>::const_iterator> m = keys2.equal_range(it1->first);
        for (multimap<string, int>::const_iterator it2 = m.first; it2 != m.second; ++it2)
        {
	  if (it2->second+w2.length()-1 < it1->second || it1->second+w1.length()-1 < it2->second)
	  {
	    if (key.empty())
	    {
	      key = it2->first;
	    }
	    else if (it2->first != key && decrypt(it2->first, c) != decrypt(key,c))
	    {
	      cout << "ambiguous" << endl;
	      goto ambiguous;
	    }
	  }
	}
      }
    }
    if (key.empty())
      cout << "impossible" << endl;
    else
      cout << decrypt(key,c) << endl;
ambiguous:;
  }
}

